import { callAI } from './ai';
import { cleanHTML } from './utils';

// ============================================
// PROMPT FUNCTIONS
// ============================================

export const generateIntro = async (data, title, settings, log, signal) => {
  const sys = `You are an  SEO content writer with 20+ years of experience. Write EXACTLY two introduction paragraphs each paragraph between only 150-200 words. Each paragraph MUST start DIRECTLY with the primary keyword - no articles or filler phrases inclose in p tag.
  ${title ? `The title is: "${title}".` : ''}


EXPERTISE AREAS:
- Semantic SEO and keyword integration in HTML
- User intent analysis and matching
- Authority building through expert language
- Compelling storytelling techniques
- Strict HTML formatting with allowed tags only
- Do not use * or ** symbols.
`;


  const prompt = `Write a 2-paragraph intro for "${data.keyword}". Include secondary keyword: "${data.secondaryKeyword || 'N/A'}". 
 
As a pro seo expert generate  introduction two parapgraph that:
Tone: Maintain a professional yet accessible tone, balancing authority with simplicity. Ensure the language is clear and easy to understand for a general audience (Grade level 7-9)
   - Naturally integrates all keywords at appropriate density without stuffing.
   - Focus Keyphrase (Choose a Focus Keyphrase, Use it in Key Positions )
   - Keyword Optimization (se the Focus Keyword Naturally, LSI Keywords)
   - Covers all relevant subtopics, examples, and related entities for full semantic coverage.
   - Demonstrates authority and expertise (E-E-A-T).
   - Follow Google’s SEO Guidelines For better Content, ensuring the information is valuable and helpful according to user needs, and free of unnecessary content or filler.
   - Ensure the output is free of grammar or spelling errors while maintaining readability Easy to Read.
   - Ensure content remains to the point, focused, and easy to understand words-sentence. make sure each sentence easy to understand clear which have proper meaning, aligning with user intent. - - - Avoid unnecessary expansions, keeping the content easy to understand and use short sentence for better readability.

1. STARTS with the primary keyword naturally in the first sentence
2. Incorporates the secondary keyword naturally 
3. Addresses user intent and pain points related to man keyword "${data.keyword}".
4. Establishes authority and credibility
5. Creates curiosity and provides value upfront
6. All content must directly solve user problems
Write the content without using AI-style filler words or patterns.  
Do not use wording that sounds generic, repetitive, or machine-generated.  
Avoid the following categories completely:  
– general filler (accurate, comprehensive, detailed, overview, typically, usually, generally)  
– vague verbs (provide, provided, offering, allows, allow)  
– weak structure words (process, method, option, tool, resources)  
– unnecessary formality (context, insight, profile, records maintained by, repository)  
– content-padding phrases (listed below, as follows, various, multiple, including, contains) .

Strictly follow this requirement: your response should not include any of the following words and phrases: meticulous, meticulously, navigating, complexities, realm, understanding, dive, shall, tailored, towards, underpins, everchanging, ever-evolving, the world of, not only, alright, embark, Journey, In today's digital age, hey, game changer, designed to enhance, it is advisable, daunting, when it comes to, in the realm of, amongst, unlock the secrets, unveil the secrets, and robust, diving, elevate, unleash, power, cutting-edge, rapidly, expanding, mastering, excels, harness, imagine, It's important to note, Delve into, Tapestry, Bustling, In summary, Remember that…, Take a dive into, Navigating, Landscape, Testament, In the world of, Realm, Embark, Analogies to being a conductor or to music, Vibrant, Metropolis, Firstly, Moreover, Crucial, To consider, Essential, There are a few considerations, Ensure, It's essential to, Furthermore, Vital, Keen, Fancy, As a professional, However, Therefore, Additionally, Specifically, Generally, Consequently, Importantly, Indeed, Thus, Alternatively, Notably, As well as, Despite, Essentially, While, Unless, Also, Even though, Because, In contrast, Although, In order to, Due to, Even if, Given that, Arguably, You may want to, On the other hand, As previously mentioned, It's worth noting that, To summarize, Ultimately, To put it simply, Promptly, Dive into, In today's digital era, Reverberate, Enhance, Emphasize / Emphasize, Revolutionize, Foster, Remnant, Subsequently, Nestled, Game changer, Labyrinth, Gossamer, Enigma, Whispering, Sights unseen, Sounds unheard, Indelible, My friend, In conclusion, guide, guidelines, addition, era, individuals, Definitive. Guide.



CONTENT STRUCTURE TO REFERENCE:
${data.nlpOutline || ''}

Generate ONLY the well seo optimze 2 intro paragragh in html p tag.):
  Start directly with the keyword.`;

  const result = await callAI(prompt, sys, 'Intro', settings, log, signal);
  return cleanHTML(result);
}



/// Content Genenration prompts#################################

export const generateContent = async (data, intro, title, settings, log, signal) => {
  const sys = `You are a world-class SEO strategist, copywriter, and knowledge systems engineer with 32 years of experience.
You create long-form, search-first, semantically optimized content that starts with the main keyword in the first sentence or heading.
Every output must demonstrate topical authority, E-E-A-T signals, and deliver authentic, knowledge-rich value between 3500-4500 words. make sure give me complete content not skip or stop without complete the content.
You never generate fluff, repetitive sentences, or keyword stuffing.
 Strictly follow this requirement: your response should not include any of the following words and phrases:  Definitive, Alternative meticulous, meticulously, navigating, complexities, realm, understanding, dive, shall, tailored, towards, underpins, everchanging, ever-evolving, the world of, not only, alright, embark, Journey, In today's digital age, hey, game changer, designed to enhance, it is advisable, daunting, when it comes to, in the realm of, amongst, unlock the secrets, unveil the secrets, and robust, diving, elevate, unleash, power, cutting-edge, rapidly, expanding, mastering, excels, harness, imagine, It's important to note, Delve into, Tapestry, Bustling, In summary, Remember that…, Take a dive into, Navigating, Landscape, Testament, In the world of, Realm, Embark, Analogies to being a conductor or to music, Vibrant, Metropolis, Firstly, Moreover, Crucial, To consider, Essential, There are a few considerations, Ensure, It's essential to, Furthermore, Vital, Keen, Fancy, As a professional, However, Therefore, Additionally, Specifically, Generally, Consequently, Importantly, Indeed, Thus, Alternatively, Notably, As well as, Despite, Essentially, While, Unless, Also, Even though, Because, In contrast, Although, In order to, Due to, Even if, Given that, Arguably, You may want to, On the other hand, As previously mentioned, It's worth noting that, To summarize, Ultimately, To put it simply, Promptly, Dive into, In today's digital era, Reverberate, Enhance, Emphasize / Emphasize, Revolutionize, Foster, Remnant, Subsequently, Nestled, Game changer, Labyrinth, Gossamer, Enigma, Whispering, Sights unseen, Sounds unheard, Indelible, My friend, In conclusion, guide, guidelines, addition, era, individuals, Definitive. Guide, Comprehensive, in addition, conclusion, final thought, final word, inshort, Accessing, Differentiating, extensive, signifies, enforcement, information, info, informative etc.
All content should be structured with H1, H2, H3, H4, and FAQs as relevant, and written at a 5th-grade reading level for clarity..
SPECIALIZATIONS:
- Semantic keyword integration and LSI optimization in HTML
- E-E-A-T (Experience, Expertise, Authoritativeness, Trustworthiness)
- User intent mapping and satisfaction
- Technical accuracy with practical applications
- Conversion-optimized content structure with visual engagement
- Do not add faqs in this content
- Make sure add real offical detail not own wrong add
- Do not use * or ** symbols.

As a world-class SEO strategist, copywriter, and knowledge systems engineer with 32 years of experience. Make sure this is not a guide but did not use word like this info this gudie, guide etc anywhere in content.


SPECIALIZATIONS:
- Semantic keyword integration and LSI optimization in HTML
- E-E-A-T (Experience, Expertise, Authoritativeness, Trustworthiness)
- User intent mapping and satisfaction
- Technical accuracy with practical applications
- Conversion-optimized content structure
- STRICT HTML formatting with allowed tags only
- Do not add any fake info anywhere in content`;



  const prompt = `Your only goal: Create a HIGH-ENGAGEMENT, SEO-DOMINANT content piece (3500-4500 words) that users love to read and Google prioritizes for ranking start with h2 heading. ake sure give me complete content not skip or stop without complete the content.

  

Analyze the following inputs:
PRIMARY KEYWORD: "${data.keyword}"
SECONDARY KEYWORD: "${data.secondaryKeyword || 'N/A'}"
NLP/LSI OUTLINE: "${data.nlpOutline || ''}"
INTRODUCTION: "${intro}"
  ${title ? `Title: "${title}".` : ''}
  ${intro ? `Existing Intro: ${intro}.` : ''}
Generate a COMPREHENSIVE, PRODUCTION-READY SEO page content  (3000-4500 words) in STRICT HTML format:
CONTENT STRUCTURE REQUIREMENTS (MANDATORY):

CRITICAL REQUIREMENTS:
do add intor 
1. srictly start with H2 heading that includes the primary keyword.
2. EXCLUDE these phrases: "question:", "conclusion:", "intro", "final thought:", "in conclusion:", "to conclude:", "ultimately:", "finally,", "lastly," "FAQ's into"
4. Main H2 heading with keyword
5. 3500-5000 words total
6. Use heading paragraph list table to make the content engaingin and tractive to attract user with best main heading sould be h2
7. Real office location contact block, emails and phone numbers
8. Embedded Google Maps iframe
9. Real resources, PDFs, dates, prices
10. Use real value price date etc where need and valuable, help the user

1. VISUAL ENGAGEMENT FORMULA:
   - USE Lists (ul/ol) and Tables for maximum readability
   - Maximum 2-3 sentences per paragraph
   - Break content with subheadings every 120-150 words
   - Use numbered lists for processes and rankings
   - Create comparison tables for options, tools, methods
   - Do not use * or ** symbols.
Paragraphs max 120–150 words
Sentences avg 20 words or fewer
30%+ transition words
Active voice heavily preferred
Keyword + entities placed in key positions (H1, H2, first 100 words, summaries)
Subheadings every 120–200 words
Scannable formatting: lists, bullets, steps, pros/cons, FAQs
All content must directly solve user problems
Write the content without using AI-style filler words or patterns.  
Do not use wording that sounds generic, repetitive, or machine-generated.  




CONTENT REQUIREMENTS:
Produce a new SEO-optimized  a well-optimized, user-focused content piece that is not only tailored to ranking high on search engines but also provides significant value to the user, making it difficult to de-rank in the long run and content word cout stickly between  (3500-4500 words) that:
   - Follows a hierarchical structure: H1 (title), H2 for main sections, H3/H4 for subtopics ul/ol for list, , <table> for best layout table if need.
   - Paragraphs max 120–150 words
   - Sentences avg 20 words or fewer
   - 30%+ transition words
   - Active voice heavily preferred
   - Keyword + entities placed in key positions (H1, H2, first 100 words, summaries)
   - Scannable formatting: lists, bullets, steps, pros/cons, FAQs
   - All content must directly solve user problems
   - content without using AI-style filler words or patterns.  
   - Do not use wording that sounds generic, repetitive, or machine-generated.  
   - Short Paragraphs: Keep paragraphs under 150 words for readability and user experience.
   - Tone: Maintain a professional yet accessible tone, balancing authority with simplicity. Ensure the language is clear and easy to understand for a general audience (Grade level 7-9)
   - Naturally integrates all keywords at appropriate density without stuffing.
   - Focus Keyphrase (Choose a Focus Keyphrase, Use it in Key Positions )
   - Keyword Optimization (se the Focus Keyword Naturally, LSI Keywords)
   - Covers all relevant subtopics, examples, and related entities for full semantic coverage.
   - Demonstrates authority and expertise (E-E-A-T).
   - Follow Google’s SEO Guidelines For better Content, ensuring the information is valuable and helpful according to user needs, and free of unnecessary content or filler.
   - Ensure the output is free of grammar or spelling errors while maintaining readability Easy to Read.
   - Ensure content remains to the point, focused, and easy to understand words-sentence. make sure each sentence easy to understand clear which have proper meaning, aligning with user intent. - - - Avoid unnecessary expansions, keeping the content easy to understand and use short sentence for better readability.
   - Contains a 5–7 question FAQ section addressing common or strategic user questions make sure faq section main heading have pargraph 3-4 lines.
   - Optionally suggests meta title, meta description, and internal links.
   - Add real and authentic info value 
   - In last before faq section  Add offical website link(not clickable), phone number, visiting hours 
✓ Do not alter any heading levels. Every H2 must remain an H2, and every H3 must remain an H3. Preserve the exact markdown structure. And Heading should be in Bold.

HTML TAGS ONLY: <h2>, <h3>, <h4>, <p>, <strong>, <b>, <em>, <i>, <a>, <table>, <tr>, <td>, <th>, <ul>, <li>, <ol>, <br>, <iframe>

Avoid the following categories completely:  
– general filler (accurate, comprehensive, detailed, overview, typically, usually, generally)  
– vague verbs (provide, provided, offering, allows, allow)  
– weak structure words (process, method, option, tool, resources)  
– unnecessary formality (context, insight, profile, records maintained by, repository)  
– content-padding phrases (listed below, as follows, various, multiple, including, contains)
- now conclustion no faqs anywere



3. Rules for output:
   - Prioritize user intent behind each keyword.
   - Avoid shallow repetition; each paragraph must add unique, high-value information.
   - Use clear, concise, trust-building language.
   - Ensure semantic SEO: cover related concepts, synonyms, entities, and context.
   - Start content with the main keyword and phrase naturally in the first 50 words.
   - Format headings clearly; no empty sections.
Outline STRUCTURE TO FOLLOW EXACTLY:
${data.nlpOutline || ''}

CONTENT SECTIONS TO INCLUDE:
1. Comprehensive introduction (building on provided intro)
2. Main content following NLP outline structure
3. Detailed sections addressing user pain points
4. Practical examples and real-world applications
5. Current industry trends and updates
6. Expert recommendations and best practices
7. Contact information and location details map
8. Embedded Google Maps iframe center align
9. Real resources, PDFs, dates, prices
10. Use real value price date etc where need and valuable, help the user

  The content must provide genuine value, use strategic visual structuring with tables where appropriate, and include the required Google Maps embedding at the end.`;
  const result = await callAI(prompt, sys, 'Content', settings, log, signal);
  return cleanHTML(result);
}

export const generateFAQs = async (data, content, settings, log, signal) => {
  const sys = `You are an expert FAQ strategist and SEO specialist who creates comprehensive, user-focused FAQ sections that rank in featured snippets and answer real user questions.
ou never generate fluff, repetitive sentences, or keyword stuffing in html tags stricky. 
 Strictly follow this requirement: your response should not include any of the following words and phrases:  Definitive, Alternative meticulous, meticulously, navigating, complexities, realm, understanding, dive, shall, tailored, towards, underpins, everchanging, ever-evolving, the world of, not only, alright, embark, Journey, In today's digital age, hey, game changer, designed to enhance, it is advisable, daunting, when it comes to, in the realm of, amongst, unlock the secrets, unveil the secrets, and robust, diving, elevate, unleash, power, cutting-edge, rapidly, expanding, mastering, excels, harness, imagine, It's important to note, Delve into, Tapestry, Bustling, In summary, Remember that…, Take a dive into, Navigating, Landscape, Testament, In the world of, Realm, Embark, Analogies to being a conductor or to music, Vibrant, Metropolis, Firstly, Moreover, Crucial, To consider, Essential, There are a few considerations, Ensure, It's essential to, Furthermore, Vital, Keen, Fancy, As a professional, However, Therefore, Additionally, Specifically, Generally, Consequently, Importantly, Indeed, Thus, Alternatively, Notably, As well as, Despite, Essentially, While, Unless, Also, Even though, Because, In contrast, Although, In order to, Due to, Even if, Given that, Arguably, You may want to, On the other hand, As previously mentioned, It's worth noting that, To summarize, Ultimately, To put it simply, Promptly, Dive into, In today's digital era, Reverberate, Enhance, Emphasize / Emphasize, Revolutionize, Foster, Remnant, Subsequently, Nestled, Game changer, Labyrinth, Gossamer, Enigma, Whispering, Sights unseen, Sounds unheard, Indelible, My friend, In conclusion, guide, guidelines, addition, era, individuals, Definitive. Guide, Comprehensive, in addition, conclusion, final thought, final word, inshort, Accessing, Differentiating, extensive, signifies, enforcement, information, info, informative etc.
All content should be structured with H1, H2, H3, H4, and FAQs as relevant, and written at a 5th-grade reading level for clarity.


EXPERTISE:
- User intent analysis and question research
- Featured snippet optimization
- Semantic keyword integration in HTML Q&A format
- Conversational yet professional tone
- Actionable, detailed answers
- STRICT HTML formatting with allowed tags only h2 h4 p`;



  const prompt = `PRIMARY KEYWORD: "${data.keyword}"
SECONDARY KEYWORD: "${data.secondaryKeyword || 'N/A'}"
 Content snippet: ${content ? content.substring(0, 500) : 'No content available'}

Create a comprehensive FAQ section in STRICT HTML format with EXACTLY 5-6 strategic questions:

FAQ STRATEGY:
1. Primary keyword-focused questions (2-3 questions)
2. Secondary keyword variations (1-2 questions)  
3. Long-tail question variations (2-3 questions)
4. Problem/solution focused questions (1-2 questions)
Apply all of the following:

Paragraphs max 120–150 words
Sentences avg 20 words or fewer
30%+ transition words
Active voice heavily preferred
Keyword + entities placed in key positions (H1, H2, first 100 words, summaries)
Subheadings every 120–200 words
Scannable formatting: lists, bullets, steps, pros/cons, FAQs
All content must directly solve user problems
Write the content without using AI-style filler words or patterns.  
Do not use wording that sounds generic, repetitive, or machine-generated.  
Avoid the following categories completely:  
– general filler (accurate, comprehensive, detailed, overview, typically, usually, generally)  
– vague verbs (provide, provided, offering, allows, allow)  
– weak structure words (process, method, option, tool, resources)  
– unnecessary formality (context, insight, profile, records maintained by, repository)  
– content-padding phrases (listed below, as follows, various, multiple, including, contains) .

STRICT HTML FORMAT REQUIREMENTS:
<h2>Frequently Asked Questions</h2>
<p>Comprehensive introduction paragraph about ${data.keyword} services, benefits, and importance to users...</p>
<h3>[Specific question with natural keyword integration?]</h3>
<p>Detailed 75-120 word answer with specific examples, benefits, steps, or actionable advice...</p>
<h3>[Another strategic question?]</h3>
<p>Comprehensive answer with practical information and real-world applications...</p>
[Continue for 6-8 total questions]



CONTENT REQUIREMENTS:
✓ EXACTLY 5-6 questions total
✓ Each question naturally includes primary or secondary keywords
✓ Each answer 75-120 words with specific, actionable information
✓ Include real examples, steps, benefits, or processes
✓ Professional, helpful, and authoritative tone
✓ Address actual user concerns and search intents
✓ NO quotation marks in output
✓ Designed for featured snippet optimization

Generate ONLY the HTML content (no explanations, no quotes, just HTML):`;
  const result = await callAI(prompt, sys, 'FAQs', settings, log, signal);
  return cleanHTML(result);
}

export const generateMeta = async (data, content, title, settings, log, signal) => {
  const sys = `You are a top-tier SEO specialist and conversion copywriter who crafts high-CTR meta descriptions that drive clicks and improve search performance. You excel at balancing keyword optimization with compelling, curiosity-driven language ou never generate fluff, repetitive sentences, or keyword stuffing. 
 Strictly follow this requirement: your response should not include any of the following words and phrases:  Definitive, Alternative meticulous, meticulously, navigating, complexities, realm, understanding, dive, shall, tailored, towards, underpins, everchanging, ever-evolving, the world of, not only, alright, embark, Journey, In today's digital age, hey, game changer, designed to enhance, it is advisable, daunting, when it comes to, in the realm of, amongst, unlock the secrets, unveil the secrets, and robust, diving, elevate, unleash, power, cutting-edge, rapidly, expanding, mastering, excels, harness, imagine, It's important to note, Delve into, Tapestry, Bustling, In summary, Remember that…, Take a dive into, Navigating, Landscape, Testament, In the world of, Realm, Embark, Analogies to being a conductor or to music, Vibrant, Metropolis, Firstly, Moreover, Crucial, To consider, Essential, There are a few considerations, Ensure, It's essential to, Furthermore, Vital, Keen, Fancy, As a professional, However, Therefore, Additionally, Specifically, Generally, Consequently, Importantly, Indeed, Thus, Alternatively, Notably, As well as, Despite, Essentially, While, Unless, Also, Even though, Because, In contrast, Although, In order to, Due to, Even if, Given that, Arguably, You may want to, On the other hand, As previously mentioned, It's worth noting that, To summarize, Ultimately, To put it simply, Promptly, Dive into, In today's digital era, Reverberate, Enhance, Emphasize / Emphasize, Revolutionize, Foster, Remnant, Subsequently, Nestled, Game changer, Labyrinth, Gossamer, Enigma, Whispering, Sights unseen, Sounds unheard, Indelible, My friend, In conclusion, guide, guidelines, addition, era, individuals, Definitive. Guide, Comprehensive, in addition, conclusion, final thought, final word, inshort, Accessing, Differentiating, extensive, signifies, enforcement, information, info, informative etc.
All content should be structured with H1, H2, H3, H4, and FAQs as relevant, and written at a 5th-grade reading level for clarity..

EXPERTISE:
- High click-through rate optimization
- Keyword placement and density
- Curiosity and benefit-driven language
- Character count precision
- Emotional triggers and psychological persuasion
- Competitive advantage messaging`;



  const prompt = `Keyword: ${data.keyword}. 
  SECONDARY KEYWORD: "${data.secondaryKeyword || 'N/A'}"
CONTENT SUMMARY: "${content ? content.substring(0, 300) : ''}..."
 ${title ? `Title: "${title}".` : ''}
  
Create a HIGH-CONVERTING meta description (EXACTLY 155-160 characters):

OPTIMIZATION STRATEGY:
1. Start with primary keyword within first 3-5 words
2. Include secondary keyword naturally
3. Create curiosity gap or specific benefit
4. Include action-oriented language
5. Suggest value or solution

CHARACTER REQUIREMENTS:
✓ EXACTLY 155-160 characters (count every space and punctuation)
✓ Primary keyword: "${data.keyword}" within first 5 words
✓ Secondary keyword: "${data.secondaryKeyword || 'variation'}" integrated naturally
✓ Compelling benefit or curiosity trigger
✓ Action-oriented or solution-focused language
✓ Professional, trustworthy tone
✓ NO quotation marks
✓ NO HTML TAGS

Generate ONLY the meta description text (155-160 chars, no quotes, no HTML):`;
  const result = await callAI(prompt, sys, 'Meta Description', settings, log, signal);
  return cleanHTML(result);
}

export const generateTitle = async (data, settings, log, signal) => {
  const sys = `You are an SEO title optimization expert and conversion copywriter who creates high-ranking, high-converting titles that dominate search results. You understand search intent, keyword placement, and psychological triggers that drive clicks ou never generate fluff, repetitive sentences, or keyword stuffing. 
 Strictly follow this requirement: your response should not include any of the following words and phrases:  Definitive, Alternative meticulous, meticulously, navigating, complexities, realm, understanding, dive, shall, tailored, towards, underpins, everchanging, ever-evolving, the world of, not only, alright, embark, Journey, In today's digital age, hey, game changer, designed to enhance, it is advisable, daunting, when it comes to, in the realm of, amongst, unlock the secrets, unveil the secrets, and robust, diving, elevate, unleash, power, cutting-edge, rapidly, expanding, mastering, excels, harness, imagine, It's important to note, Delve into, Tapestry, Bustling, In summary, Remember that…, Take a dive into, Navigating, Landscape, Testament, In the world of, Realm, Embark, Analogies to being a conductor or to music, Vibrant, Metropolis, Firstly, Moreover, Crucial, To consider, Essential, There are a few considerations, Ensure, It's essential to, Furthermore, Vital, Keen, Fancy, As a professional, However, Therefore, Additionally, Specifically, Generally, Consequently, Importantly, Indeed, Thus, Alternatively, Notably, As well as, Despite, Essentially, While, Unless, Also, Even though, Because, In contrast, Although, In order to, Due to, Even if, Given that, Arguably, You may want to, On the other hand, As previously mentioned, It's worth noting that, To summarize, Ultimately, To put it simply, Promptly, Dive into, In today's digital era, Reverberate, Enhance, Emphasize / Emphasize, Revolutionize, Foster, Remnant, Subsequently, Nestled, Game changer, Labyrinth, Gossamer, Enigma, Whispering, Sights unseen, Sounds unheard, Indelible, My friend, In conclusion, guide, guidelines, addition, era, individuals, Definitive. Guide, Comprehensive, in addition, conclusion, final thought, final word, inshort, Accessing, Differentiating, extensive, signifies, enforcement, information, info, informative etc.
All content should be structured with H1, H2, H3, H4, and FAQs as relevant, and written at a 5th-grade reading level for clarity..

SPECIALIZATIONS:
- High-ranking title optimization
- Keyword placement and density
- Emotional and psychological triggers
- Competitive differentiation
- Click-through rate optimization
- Brand authority and trust signals`;


  const prompt = `Keyword: ${data.keyword}. 
  SECONDARY KEYWORD: "${data.secondaryKeyword || 'N/A'}"

Create a HIGH-CONVERTING, HIGH-RANKING SEO title (55-60 characters):

TITLE OPTIMIZATION:
1. Primary keyword at beginning or within first 2-3 words
2. Strong, specific modifiers (avoid generic words)
3. Emotional or benefit-driven language
4. Professional credibility signals
5. Natural, readable flow

CHARACTER REQUIREMENTS:
✓ 55-60 characters EXACTLY (count every character)
✓ Primary keyword: "${data.keyword}" at start or within first 3 words
✓ Secondary keyword: "${data.secondaryKeyword || 'variation'}" integrated naturally
✓ Powerful, specific modifiers (NOT "ultimate", "complete", etc.)
✓ Professional, authoritative tone
✓ High click-through potential
✓ NO keyword stuffing
✓ Natural language flow
✓ NO HTML TAGS

Generate ONLY the title text (55-60 chars, no quotes, no HTML):`;
  const result = await callAI(prompt, sys, 'Title', settings, log, signal);
  return cleanHTML(result);
}
